<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Mod Request Form</title>
<style>
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
    background-color: #1e1e1e; /* Dark background */
    color: #fff; /* Light text */
}

.container {
    max-width: 500px;
    margin: 50px auto;
    padding: 20px;
    background-color: #2a2a2a; /* Darker container background */
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

h2 {
    text-align: center;
    color: #fff; /* Light text */
}

.form-group {
    margin-bottom: 20px;
}

label {
    display: block;
    margin-bottom: 5px;
    color: #fff; /* Light text */
}

input[type="text"],
input[type="url"],
textarea {
    width: 100%;
    padding: 10px;
    border: 1px solid #666; /* Darker border */
    border-radius: 5px;
    box-sizing: border-box;
    background-color: #333; /* Darker input background */
    color: #fff; /* Light text */
}

textarea {
    height: 100px;
}

button {
    width: 100%;
    padding: 10px;
    background-color: #007bff;
    color: #fff;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}

button:hover {
    background-color: #0056b3;
}
</style>
</head>
<body>

<div class="container">
    <h2>RWT Mod Request Form</h2>
    <form action="<?php echo htmlspecialchars($_SERVER["PHP_SELF"]); ?>" method="post">
        <div class="form-group">
            <label for="discord_username">Discord Username:</label>
            <input type="text" id="discord_username" name="discord_username" required>
        </div>
        <div class="form-group">
            <label for="in_game_name">In-Game Name:</label>
            <input type="text" id="in_game_name" name="in_game_name" required>
        </div>
        <div class="form-group">
            <label for="steam_workshop_link">Link to Mod's Steam Workshop Page:<BR>
            <font size=1>Example: https://steamcommunity.com/sharedfiles/filedetails/?id=3005289691</font></label>
            <input type="url" id="steam_workshop_link" name="steam_workshop_link" required>
        </div>
        <button type="submit">Submit</button>
    </form>
</div>

<?php

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $discordUsername = $_POST['discord_username'];
    $inGameName = $_POST['in_game_name'];
    $steamWorkshopLink = $_POST['steam_workshop_link'];

   // $discordMessage = ".\nDiscord Username: $discordUsername\nIn-Game Name: $inGameName\nMod URL: $steamWorkshopLink\n \nThe above mod has been added as an optional mod.\n \nThis will allow you to use it on the server but when others try to interact with your colony it will cause issues.\n \nIf you plan on interacting with other colonies it is recommended to use only the mods from Mods.txt\n \nAdded mods won't be active until after the server reboots at 7 a.m. (-5 UTC)";
    $discordMessage = ".\nDiscord Username: $discordUsername\nIn-Game Name: $inGameName\nMod URL: $steamWorkshopLink";
    // $webhookURL = 'https://discord.com/api/webhooks/1218274446746587157/Sex8K_U4r6IH_s047MIdQREOm7gm7suXxhRKWSf_2JgKXT7iljYSHw7NjvkBdQT1PEbK';

    // Custom bot name and avatar
    $botName = "New Mod Request";
    $botAvatar = "https://i.imgur.com/qnLXXhk.png"; // URL to the avatar image

    // Construct payload with custom name and avatar
    $payload = json_encode(array(
        "username" => $botName,
        "avatar_url" => $botAvatar,
        "content" => $discordMessage
    ));

    $options = array(
        'http' => array(
            'header' => "Content-Type: application/json\r\n",
            'method' => 'POST',
            'content' => $payload
        )
    );
    $context = stream_context_create($options);
    $result = file_get_contents($webhookURL, false, $context);

    if ($result !== false) {
        echo '<script>alert("Form submission successful")</script>';
    } else {
        echo '<script>alert("Error submitting form")</script>';
    }
}

?>

<?php
//$steamWorkshopLink = "your_steam_workshop_link_here";

// Escaping the variable to prevent shell injection
$escapedLink = escapeshellarg($steamWorkshopLink);

// Calling the bash script with $steamWorkshopLink passed directly
shell_exec("bash /home/rimworld/one-off-mod-dl.sh $escapedLink");
?>

<center>
This is a request, not a guarantee.<br>
We will get back to you if we have any questions.<br>
<br>
If a mod is added, it will be an optional mod. This will allow you to use it on the server but when others try to interact with your colony it will cause issues.<br>
If you plan on interacting with other colonies it is recommended to use only the mods from Mods.txt<br>
<br>

Added mods won't be active until after the server reboots at 7 a.m. (-5 UTC)
<br>
<a href="https://claytonia.net/assets/Rimworld/OptionalMods.php">Here</a> is a list of the currently active optional mods
</body>
</html>
