#!/bin/bash

#Dotnet Path for starting the server
export DOTNET_ROOT=$HOME/dotnet
export PATH=$PATH:$HOME/dotnet


# Set the GitHub repository
REPO="Nova-Atomic/Rimworld-Together"

# Set the platform
#This is how it finds what release to grab.
#It should be part of the file name you want under Assests on the release page.
SEARCH="Linux-x64"

# Path to the SteamCMD executable
STEAMCMD_PATH="/opt/steamcmd/steamcmd.sh"

# Path to the text file containing workshop IDs (one ID per line)
WORKSHOP_IDS_FILE="/home/rimworld/workshop_ids.txt"

# Path to the directory where you want to install the workshop items
#mods will be in $INSTALL_DIR/steamapps/workshop/content/$APP_ID/$workshop_id/
INSTALL_DIR="/home/rimworld/"

# AppID for the game (replace with the appropriate AppID)
APP_ID="294100"  

cd "/home/rimworld/" || exit 


# Update Mods

# Ensure the SteamCMD executable exists
if [ ! -f "$STEAMCMD_PATH" ]; then
    echo "Error: SteamCMD not found at $STEAMCMD_PATH. Please provide the correct path."
    exit 1
fi



# Loop through each workshop ID in the file
while IFS= read -r workshop_id || [ -n "$workshop_id" ]; do
    # Run SteamCMD to install the workshop item
    "$STEAMCMD_PATH" +force_install_dir "$INSTALL_DIR" +login anonymous +workshop_download_item "$APP_ID" "$workshop_id" +quit
    
    echo
    echo
    echo
    echo "Installed workshop item with ID $workshop_id"
    echo
    
    #Rate Limit fix
    sleep 5
done < "$WORKSHOP_IDS_FILE"



# Update RWT


# Fetch the latest release information using the GitHub API
RELEASE_INFO=$(curl -s "https://api.github.com/repos/$REPO/releases/latest")

# Extract the version using jq and store it in version.txt
NEW_VERSION=$(echo "$RELEASE_INFO" | jq -r ".tag_name" | sed 's/[^0-9]*//g')
CURRENT_VERSION=$(cat version.txt 2>/dev/null)

# Check if version.txt exists and if the latest version is newer
if [ -z "$CURRENT_VERSION" ] || [ "$NEW_VERSION" -gt "$CURRENT_VERSION" ]; then
    echo "Newer version available. Updating version.txt and downloading..."

    # Update version.txt with the new version
    echo "$NEW_VERSION" > version.txt

    # Extract the download URLs for all assets
    DOWNLOAD_URLS=$(echo "$RELEASE_INFO" | jq -r '.assets[] | .browser_download_url')

    # Loop through each download URL and find the one containing the SEARCH string
    for URL in $DOWNLOAD_URLS; do
        if [[ $URL == *"$SEARCH"* ]]; then
            DOWNLOAD_URL=$URL
            break
        fi
    done

    # Download the release
    if [ -n "$DOWNLOAD_URL" ]; then
        echo "Downloading $DOWNLOAD_URL"
        curl -LOs "$DOWNLOAD_URL"
        echo "Download complete."

        # Check if a tar file exists in the directory
        #Change file extension as needed!
        if [ -e *.zip ]; then
            # Extract the tar file
            echo "Extracting zip file..."
            unzip -o *.zip

            # Delete the tar file
            echo "Deleting zip file..."
            rm -f *.zip
            echo "Zip file deleted."
        else
            echo "Error: No tar file found in the directory."
            exit 1
        fi
    else
        echo "Error: Unable to find download URL for $SEARCH."
        exit 1
    fi
else
    echo "Already up-to-date. No need to download."
fi


exit

#sync the config files with the website.
rsync -av --include='*.json' --exclude='*' --stats "/home/rimworld/Core/" "/var/www/html/assets/Rimworld/"

#Run the server
cd /home/rimworld/ || exit 1
./GameServer


exit
