<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Claytonia RWT Optional Mods</title>
<style>
body {
    font-family: Arial, sans-serif;
    margin: 0;
    padding: 0;
    background-color: #1e1e1e; /* Dark background */
    color: #fff; /* Light text */
}

.container {
    max-width: 500px;
    margin: 50px auto;
    padding: 20px;
    background-color: #2a2a2a; /* Darker container background */
    border-radius: 8px;
    box-shadow: 0 0 10px rgba(0, 0, 0, 0.1);
}

h2 {
    text-align: center;
    color: #fff; /* Light text */
}

.form-group {
    margin-bottom: 20px;
}

label {
    display: block;
    margin-bottom: 5px;
    color: #fff; /* Light text */
}

input[type="text"],
input[type="url"],
textarea {
    width: 100%;
    padding: 10px;
    border: 1px solid #666; /* Darker border */
    border-radius: 5px;
    box-sizing: border-box;
    background-color: #333; /* Darker input background */
    color: #fff; /* Light text */
}

textarea {
    height: 100px;
}

button {
    width: 100%;
    padding: 10px;
    background-color: #007bff; 
    color: #fff;
    border: none;
    border-radius: 5px;
    cursor: pointer;
}

button:hover {
    background-color: #0056b3;
}
</style>


<body>
<H1> Current Optional Mods</H1>
<?php
$directory = '/home/rimworld/Mods/Optional';
$urlPrefix = 'https://steamcommunity.com/sharedfiles/filedetails/?id=';

// Open the directory
if ($handle = opendir($directory)) {
    // Loop through the directory
    while (false !== ($entry = readdir($handle))) {
        // Exclude current and parent directory entries
        if ($entry != "." && $entry != ".." && is_dir("$directory/$entry")) {
            // Prepend URL prefix to each directory name and create a clickable link
            $url = $urlPrefix . urlencode($entry);

            // Get webpage title
            $pageTitle = getPageTitle($url);

            // Extract the second part of the title after "::"
            $titleParts = explode("::", $pageTitle);
            $secondPart = isset($titleParts[1]) ? trim($titleParts[1]) : '';

            // Display clickable link with the second part of the title
            echo "<a href=\"$url\">$entry</a> - $secondPart<br>\n";
        }
    }
    // Close the directory handle
    closedir($handle);
}

// Function to get webpage title
function getPageTitle($url) {
    $html = file_get_contents($url);
    if ($html !== false) {
        if (preg_match('/<title>(.*?)<\/title>/', $html, $matches)) {
            return $matches[1];
        } else {
            return "Title not found";
        }
    } else {
        return "Failed to fetch title";
    }
}
?>

</body>
</html>
